
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("farm_optimization")

# Create variables
x = m.addVar(lb=0, name="corn_acres")
y = m.addVar(lb=0, name="cabbage_acres")

# Set objective function
m.setObjective(50*x + 70*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + y <= 200, "land_constraint")
m.addConstr(x + 1.5*y <= 200, "tractor_constraint")
m.addConstr(2*x + 3*y <= 275, "handpicking_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Plant {x.x} acres of corn")
    print(f"Plant {y.x} acres of cabbage")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

