
from gurobipy import *

# Create a model
m = Model("Farm_Optimization")

# Define variables
x = m.addVar(name="corn_acres", vtype=GRB.CONTINUOUS, lb=0)
y = m.addVar(name="cabbage_acres", vtype=GRB.CONTINUOUS, lb=0)

# Set the objective function (maximize profit)
m.setObjective(50*x + 70*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x + 1.5*y <= 200, name="tractor_time")
m.addConstr(2*x + 3*y <= 275, name="hand_picking_time")
m.addConstr(x + y <= 200, name="land_availability")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum profit: {m.objVal}")
else:
    print("No optimal solution found")
