
import gurobi

def solve_farm_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x_c = model.addVar(lb=0, name="corn_acres")
    x_cb = model.addVar(lb=0, name="cabbage_acres")

    # Objective function: maximize profit
    model.setObjective(50 * x_c + 70 * x_cb, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(x_c + 1.5 * x_cb <= 200, name="tractor_time")
    model.addConstr(2 * x_c + 3 * x_cb <= 275, name="hand_picking_time")
    model.addConstr(x_c + x_cb <= 200, name="land_availability")

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Corn acres: {x_c.x}")
        print(f"Cabbage acres: {x_cb.x}")
        print(f"Max profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_farm_problem()
