
import gurobipy as gp

# Create a new model
m = gp.Model("tshirt_sweater_optimization")

# Create variables
x = m.addVar(vtype=gp.GRB.INTEGER, name="t_shirts")
y = m.addVar(vtype=gp.GRB.INTEGER, name="sweaters")

# Set objective function
m.setObjective(15*x + 20*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x + 30*y <= 1000, "budget")
m.addConstr(x >= 20, "min_tshirts")
m.addConstr(x <= 40, "max_tshirts")
m.addConstr(y <= 0.5*x, "sweater_limit")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of T-shirts to buy/sell (x): {x.x}")
    print(f"Number of Sweaters to buy/sell (y): {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

