
from gurobipy import *

# Create a model
m = Model("T-Shirts_and_Sweaters")

# Define variables
t = m.addVar(lb=20, ub=40, vtype=GRB.INTEGER, name="t-shirts")
s = m.addVar(lb=0, ub=20, vtype=GRB.INTEGER, name="sweaters")

# Add constraints
m.addConstr(20*t + 30*s <= 1000, "budget_constraint")
m.addConstr(s <= 0.5*t, "sweater_limit")

# Set objective function to maximize profit
m.setObjective(15*t + 20*s, GRB.MAXIMIZE)

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Buy {t.x} t-shirts and {s.x} sweaters.")
    print(f"Maximum profit: ${15*t.x + 20*s.x}")
else:
    print("No optimal solution found")
