
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=0, ub=40, vtype=gurobi.GRB.INTEGER, name="t-shirts")
    y = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="sweaters")

    # Objective function: Maximize profit
    model.setObjective(15*x + 20*y, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(20*x + 30*y <= 1000, name="budget_constraint")

    # T-shirt sales constraint: at least 20
    model.addConstr(x >= 20, name="min_tshirts_constraint")

    # Sweater sales constraint: at most half the number of t-shirts
    model.addConstr(y <= 0.5*x, name="sweaters_vs_tshirts_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Buy and sell {x.varValue} t-shirts and {y.varValue} sweaters.")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
