
from gurobipy import *

# Create a new model
m = Model("Maple_Farm_Optimization")

# Define the decision variables
x = m.addVar(lb=3, ub=10, name="maple_syrup")  # Amount of maple syrup (kg)
y = m.addVar(lb=5, ub=12, name="maple_candy")  # Amount of maple candy (kg)

# Define the objective function
m.setObjective(20*x + 15*y, GRB.MAXIMIZE)

# Define the constraints
m.addConstr(2*x + 2*y <= 20, name="boiling_station_time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Maple Syrup: {x.x} kg")
    print(f"Maple Candy: {y.x} kg")
    print(f"Maximum Profit: ${m.objVal}")
else:
    print("No optimal solution found")

