
import gurobi

def solve_maple_farm_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(lb=3, ub=10, name="maple_syrup")  # kg
    y = model.addVar(lb=5, ub=12, name="maple_candy")  # kg

    # Objective function: Maximize profit
    model.setObjective(20 * x + 15 * y, gurobi.GRB.MAXIMIZE)

    # Boiling station constraint
    model.addConstraint(2 * x + 2 * y <= 20)

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
        print(f"Maximum profit: ${20 * x.varValue + 15 * y.varValue}")
    else:
        print("The model is infeasible.")

solve_maple_farm_problem()
