
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("taco_optimization")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="burritos")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="tacos")

# Set objective function
m.setObjective(3*x + 3.5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*x + 4.5*y <= 500, "beef_constraint")
m.addConstr(4*x + 3*y <= 400, "toppings_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal profit: ${m.objVal:.2f}")
    print(f"Number of burritos to sell: {x.x:.2f}")
    print(f"Number of tacos to sell: {y.x:.2f}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}.")

