
from gurobipy import *

# Create a new model
m = Model("Taco_Restaurant")

# Define the decision variables
B = m.addVar(vtype=GRB.CONTINUOUS, name="burritos", lb=0)
T = m.addVar(vtype=GRB.CONTINUOUS, name="tacos", lb=0)

# Set the objective function
m.setObjective(3*B + 3.5*T, GRB.MAXIMIZE)

# Add constraints
m.addConstr(4*B + 4.5*T <= 500, "beef_constraint")
m.addConstr(4*B + 3*T <= 400, "toppings_constraint")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Burritos to sell: {B.x}")
    print(f"Tacos to sell: {T.x}")
    print(f"Total profit: ${3*B.x + 3.5*T.x:.2f}")
else:
    print("No optimal solution found")
