
import gurobi

def solve_taco_restaurant_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    B = model.addVar(lb=0, name="Burritos", vtype=gurobi.GRB.CONTINUOUS)
    T = model.addVar(lb=0, name="Tacos", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(3*B + 3.50*T, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(4*B + 4.5*T <= 500, name="Beef_Constraint")
    model.addConstr(4*B + 3*T <= 400, name="Toppings_Constraint")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution found. Burritos: {B.varValue}, Tacos: {T.varValue}")
        print(f"Max Profit: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_taco_restaurant_problem()
