
from gurobipy import *

# Create a new model
m = Model("Wage_Bill_Minimization")

# Define variables
W = m.addVar(lb=0, name="Waiters")
C = m.addVar(lb=0, name="Cooks")

# Set the objective function
m.setObjective(147*W + 290*C, GRB.MINIMIZE)

# Add constraints
m.addConstr(W + C >= 50, name="Total_Staff")
m.addConstr(C >= 12, name="Minimum_Cooks")
m.addConstr(C >= (1/3)*W, name="Union_Regulation")
m.addConstr(147*W + 290*C <= 17600, name="Weekly_Wage_Bill")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Waiters: {W.x}")
    print(f"Cooks: {C.x}")
    print(f"Wage Bill: ${147*W.x + 290*C.x:.2f}")
else:
    print("No optimal solution found")
