
import gurobi

def solve_restaurant_staffing_problem():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    W = model.addVar(lb=0, name="Waiters", vtype=gurobi.GRB.INTEGER)
    C = model.addVar(lb=0, name="Cooks", vtype=gurobi.GRB.INTEGER)

    # Objective function: Minimize the wage bill
    model.setObjective(147 * W + 290 * C, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(W + C >= 50, name="Total_Staff")
    model.addConstr(C >= 12, name="Minimum_Cooks")
    model.addConstr(C >= W / 3, name="Union_Regulations")
    model.addConstr(147 * W + 290 * C <= 17600, name="Wage_Bill")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Waiters: {W.varValue}")
        print(f"Cooks: {C.varValue}")
        print(f"Minimum Wage Bill: ${model.objVal:.2f}")
    else:
        print("The model is infeasible.")

solve_restaurant_staffing_problem()
