
import gurobipy as gp

# Create a new model
model = gp.Model("pants_production")

# Create decision variables
x = model.addVar(vtype=gp.GRB.CONTINUOUS, name="grey_pants")
y = model.addVar(vtype=gp.GRB.CONTINUOUS, name="black_pants")

# Set objective function
model.setObjective(25 * x + 15 * y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(40 * x + 20 * y <= 2100, "wimo_constraint")
model.addConstr(30 * x + 15 * y <= 3000, "webo_constraint")
model.addConstr(x >= 0, "grey_nonneg")
model.addConstr(y >= 0, "black_nonneg")

# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal profit: {model.objVal}")
    print(f"Number of grey pants: {x.x}")
    print(f"Number of black pants: {y.x}")
else:
    print("No solution found.")

