
from gurobipy import *

# Create a new model
m = Model("Clothing_Production")

# Decision variables: Number of pairs of grey and black pants to produce
G = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="GreyPants")
B = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="BlackPants")

# Objective function: Maximize total production (as a proxy for maximizing profit)
m.setObjective(G + B, GRB.MAXIMIZE)

# Constraints
# 1. Wimo's processing time constraint
m.addConstr(40*G + 20*B <= 2100, name="Wimo_Time")

# 2. Webo's processing time constraint
m.addConstr(30*G + 15*B <= 3000, name="Webo_Time")

# Solve the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grey Pants: {G.x}")
    print(f"Black Pants: {B.x}")
else:
    print("No optimal solution found.")
