
import gurobi

def solve_pant_production_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define decision variables
    G = model.addVar(name="Grey_Pants", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    B = model.addVar(name="Black_Pants", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Define objective function
    model.setObjective(25 * G + 15 * B, gurobi.GRB.MAXIMIZE)

    # Define constraints
    model.addConstr(40 * G + 20 * B <= 2100, name="Wimo_Constraint")
    model.addConstr(30 * G + 15 * B <= 3000, name="Webo_Constraint")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Grey Pants = {G.varValue:.2f}, Black Pants = {B.varValue:.2f}")
        print(f"Max Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found")

solve_pant_production_problem()
