
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Oil_Production")

# Create decision variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="Regular_Synthetic")
y = m.addVar(vtype=GRB.CONTINUOUS, name="Premium_Synthetic")

# Set objective function
m.setObjective(17.4 * x + 11.1 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(25 * x + 10 * y <= 1000, "Substance_A")
m.addConstr(40 * x + 25 * y <= 500, "Substance_B")
m.addConstr(36 * x + 40 * y <= 900, "Substance_C")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Regular Synthetic (x): {x.x}")
    print(f"Premium Synthetic (y): {y.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

