
from gurobipy import *

# Create a model
m = Model("Oil_Production")

# Decision Variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="Regular_Synthetic", lb=0)
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="Premium_Synthetic", lb=0)

# Objective Function: Maximize Profit
m.setObjective(17.4*x1 + 11.1*x2, GRB.MAXIMIZE)

# Constraints
m.addConstr(25*x1 + 10*x2 <= 1000, "Substance_A")
m.addConstr(40*x1 + 25*x2 <= 500, "Substance_B")
m.addConstr(36*x1 + 40*x2 <= 900, "Substance_C")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Produce {x1.x} containers of Regular Synthetic and {x2.x} containers of Premium Synthetic.")
else:
    print("No optimal solution found.")

