
import gurobi as gp

# Create a new model
model = gp.Model("Car_Oil_Production")

# Define the decision variables
R = model.addVar(name="Regular_Synthetic", lb=0, vtype=gp.GRB.CONTINUOUS)
P = model.addVar(name="Premium_Synthetic", lb=0, vtype=gp.GRB.CONTINUOUS)

# Objective function: Maximize profit
model.setObjective(17.4 * R + 11.1 * P, sense=gp.GRB.MAXIMIZE)

# Constraints
model.addConstr(25 * R + 10 * P <= 1000, name="Substance_A")
model.addConstr(40 * R + 25 * P <= 500, name="Substance_B")
model.addConstr(36 * R + 40 * P <= 900, name="Substance_C")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Regular Synthetic: {R.varValue} containers")
    print(f"Premium Synthetic: {P.varValue} containers")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("No optimal solution found.")
