
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("furniture_production")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="chairs")
y = m.addVar(vtype=GRB.CONTINUOUS, name="shelves")

# Set objective
m.setObjective(50 * x + 55 * y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30 * x + 20 * y <= 3000, "assembly_time")
m.addConstr(50 * x + 60 * y <= 4000, "painting_time")
m.addConstr(x >= 0, "chairs_non_negative")  # explicitly add non-negativity
m.addConstr(y >= 0, "shelves_non_negative") # explicitly add non-negativity


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of chairs to produce: {x.x}")
    print(f"Number of shelves to produce: {y.x}")
    print(f"Maximum profit: ${m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

