
from gurobipy import *

# Create a new model
m = Model("Furniture_Company")

# Define the decision variables
C = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Chairs")
S = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="Shelves")

# Set the objective function: Maximize profit
m.setObjective(50*C + 55*S, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*C + 20*S <= 3000, "Assembly_Time")
m.addConstr(50*C + 60*S <= 4000, "Painting_Time")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: Produce {C.x} chairs and {S.x} shelves.")
    print(f"Maximum profit: ${50*C.x + 55*S.x}")
else:
    print("No optimal solution found")
