
import gurobi

def solve_furniture_production_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x = model.addVar(name="chairs", lb=0, vtype=gurobi.GRB.CONTINUOUS)
    y = model.addVar(name="shelves", lb=0, vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize profit
    model.setObjective(50 * x + 55 * y, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(30 * x + 20 * y <= 3000, name="assembly_time")
    model.addConstr(50 * x + 60 * y <= 4000, name="painting_time")

    # Optimize model
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal production levels: Chairs = {x.varValue}, Shelves = {y.varValue}")
        print(f"Maximum profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

# Run the function
solve_furniture_production_problem()
