
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("arcade_shooting")

    # Create variables
    x = m.addVar(vtype=GRB.INTEGER, name="deer")
    y = m.addVar(vtype=GRB.INTEGER, name="bears")

    # Set objective
    m.setObjective(4*x + 10*y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x >= 5, "min_deer")
    m.addConstr(y >= 2, "min_bears")
    m.addConstr(x <= 10, "max_deer")
    m.addConstr(y <= 5, "max_bears")
    m.addConstr(x + y <= 12, "total_shots")

    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print(f"Optimal Solution Found:")
        print(f"Shoot {x.x} deer")
        print(f"Shoot {y.x} bears")
        print(f"Total points: {m.objVal}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
