
from gurobipy import *

# Create a new model
m = Model("Arcade_Shooting_Game")

# Define decision variables
D = m.addVar(lb=5, ub=10, vtype=GRB.INTEGER, name="Deer")
B = m.addVar(lb=2, ub=5, vtype=GRB.INTEGER, name="Bear")

# Set the objective function
m.setObjective(4*D + 10*B, GRB.MAXIMIZE)

# Add constraints
m.addConstr(D + B <= 12, "Total_Animals")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Shoot {D.x} deer")
    print(f"Shoot {B.x} bears")
    print(f"Maximum points: {m.objVal}")
else:
    print("No optimal solution found")

