
import gurobi

def solve_arcade_shooting_game():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables with their bounds
    D = model.addVar(lb=5, ub=10, name="Deer")
    B = model.addVar(lb=2, ub=5, name="Bears")

    # Objective function: Maximize 4D + 10B
    model.setObjective(4 * D + 10 * B, gurobi.GRB.MAXIMIZE)

    # Additional constraint: D + B <= 12
    model.addConstr(D + B <= 12, name="Total_Bullets")

    # Solve the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution: Deer = {D.varValue}, Bears = {B.varValue}")
        print(f"Max Points: {4 * D.varValue + 10 * B.varValue}")
    else:
        print("The model is infeasible.")

solve_arcade_shooting_game()
