
import gurobipy as gp

# Create a new model
model = gp.Model("Animal_Sculptures")

# Create decision variables
x = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="elephants") # Number of elephants
y = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="lions")     # Number of lions

# Set objective function
model.setObjective(50*x + 45*y, gp.GRB.MAXIMIZE)

# Add constraints
model.addConstr(10*x + 8*y <= 300, "clay_constraint")
model.addConstr(x + y <= 33, "animal_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of elephants: {x.x}")
    print(f"Number of lions: {y.x}")
    print(f"Maximum Profit: ${model.objVal}")
else:
    print("No solution found or infeasible.")

