
from gurobipy import *

# Create a new model
m = Model("Artist_Profit_Optimization")

# Define variables
x = m.addVar(name="mini_elephants", lb=0, vtype=GRB.CONTINUOUS)
y = m.addVar(name="mini_lions", lb=0, vtype=GRB.CONTINUOUS)

# Set the objective function: Maximize profit
m.setObjective(50*x + 45*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(10*x + 8*y <= 300, name="clay_availability")
m.addConstr(x + y <= 33, name="time_constraint")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.x}, y = {y.x}")
    print(f"Maximum profit: ${50*x.x + 45*y.x:.2f}")
else:
    print("No optimal solution found")

