
from gurobipy import *

# Create a new model
model = Model("Artist Production Problem")

# Define variables
E = model.addVar(lb=0, name="Mini_Elephants", vtype=GRB.INTEGER)  # Number of mini elephants
L = model.addVar(lb=0, name="Mini_Lions", vtype=GRB.INTEGER)     # Number of mini lions

# Objective function: Maximize profit
model.setObjective(50*E + 45*L, GRB.MAXIMIZE)

# Constraints
model.addConstr(10*E + 8*L <= 300, name="Clay_Constraint")         # Clay constraint
model.addConstr(E + L <= 33, name="Production_Limit_Constraint")    # Production limit constraint

# Solve the model
model.optimize()

# Check if the model is optimized
if model.status == GRB.Status.OPTIMAL:
    print(f"Optimal Solution: Mini Elephants = {E.varValue}, Mini Lions = {L.varValue}")
    print(f"Max Profit: ${model.objVal:.2f}")
else:
    print("The model is infeasible.")
