
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Investment_Problem")

# Create decision variables
x1 = m.addVar(lb=0, name="Delta_Investment")
x2 = m.addVar(lb=0, name="Omega_Investment")

# Set objective function
m.setObjective(0.8 * x1 + 1.2 * x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(x1 + x2 <= 100000, "Budget_Constraint")
m.addConstr(x1 >= 0.25 * (x1 + x2), "Min_Delta_Investment")
m.addConstr(x2 >= 10000, "Min_Omega_Investment")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Profit: ${m.objVal}")
    print(f"Investment in Delta: ${x1.x}")
    print(f"Investment in Omega: ${x2.x}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

