
from gurobipy import *

# Create a new model
m = Model("Investment_Problem")

# Decision Variables
D = m.addVar(name='Delta', vtype=GRB.CONTINUOUS, lb=0)
O = m.addVar(name='Omega', vtype=GRB.CONTINUOUS, lb=0)

# Objective Function: Maximize profit
m.setObjective(0.80*D + 1.20*O, GRB.MAXIMIZE)

# Constraints
m.addConstr(D + O <= 100000, name='Budget_Constraint')
m.addConstr(3*D >= O, name='Delta_Minimum_Constraint')
m.addConstr(O >= 10000, name='Omega_Minimum_Constraint')

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print('Invest in Delta: $', D.x)
    print('Invest in Omega: $', O.x)
    print('Total Profit: $', m.objVal)
else:
    print('No optimal solution found')
