
import gurobi

def solve_investment_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_D = model.addVar(name="Delta_Investment", lb=0)
    x_O = model.addVar(name="Omega_Investment", lb=0)

    # Objective function: Maximize profit
    model.setObjective(0.80 * x_D + 1.20 * x_O, gurobi.GRB.MAXIMIZE)

    # Budget constraint
    model.addConstr(x_D + x_O <= 100000, name="Budget_Constraint")

    # Minimum Delta investment constraint
    model.addConstr(3 * x_D >= x_O, name="Delta_Min_Constraint")

    # Minimum Omega investment constraint
    model.addConstr(x_O >= 10000, name="Omega_Min_Constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Delta Investment: ${x_D.x:.2f}")
        print(f"Omega Investment: ${x_O.x:.2f}")
        print(f"Total Profit: ${model.objVal:.2f}")
    else:
        print("No optimal solution found.")

solve_investment_problem()
