
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("smoothie_optimization")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="small_smoothies")
y = m.addVar(vtype=GRB.INTEGER, name="large_smoothies")

# Set objective function
m.setObjective(3*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + 3*y <= 20, "ice_cream_constraint")
m.addConstr(x + 2*y <= 18, "peanut_butter_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of small smoothies (x): {x.x}")
    print(f"Number of large smoothies (y): {y.x}")
    print(f"Maximum Profit: {m.objVal}")
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

