
from gurobipy import *

# Create a model
m = Model("Smoothie_Optimization")

# Define decision variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="small_smoothies")
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="large_smoothies")

# Set the objective function
m.setObjective(3*x + 5*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x + 3*y <= 20, "ice_cream_constraint")
m.addConstr(x + 2*y <= 18, "peanut_butter_constraint")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")
