
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the decision variables
x = m.addVar(lb=0, name="small_smoothies")
y = m.addVar(lb=0, name="large_smoothies")

# Define the objective function
m.setObjective(3*x + 5*y, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(2*x + 3*y <= 20, name="ice_cream_constraint")
m.addConstr(x + 2*y <= 18, name="peanut_butter_constraint")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Small smoothies: {x.varValue}")
    print(f"Large smoothies: {y.varValue}")
    print(f"Max profit: {m.objVal}")
else:
    print("No optimal solution found.")
