
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("PumpkinTransportation")

# Create variables
x = m.addVar(vtype=GRB.INTEGER, name="x") # Number of truck trips
y = m.addVar(vtype=GRB.INTEGER, name="y") # Number of van trips


# Set objective function
m.setObjective(40*x + 25*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*x + 10*y <= 300, "Budget")
m.addConstr(x <= y, "TruckLimit")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of truck trips (x): {x.x}")
    print(f"Number of van trips (y): {y.x}")
    print(f"Total pumpkins transported: {40*x.x + 25*y.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization ended with status {m.status}")

