
from gurobipy import *

# Create a new model
m = Model("Pumpkin_Transportation")

# Define variables
T = m.addVar(vtype=GRB.INTEGER, name="Truck_Trips")
V = m.addVar(vtype=GRB.INTEGER, name="Van_Trips")

# Set the objective
m.setObjective(40*T + 25*V, GRB.MAXIMIZE)

# Add constraints
m.addConstr(15*T + 10*V <= 300, "Cost_Constraint")
m.addConstr(T <= V, "Truck_Van_Constraint")
m.addConstr(T >= 0, "Non_Negativity_Truck")
m.addConstr(V >= 0, "Non_Negativity_Van")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Number of truck trips: {T.x}")
    print(f"Number of van trips: {V.x}")
    print(f"Total pumpkins transported: {40*T.x + 25*V.x}")
else:
    print("No optimal solution found.")
