
import gurobi

def solve_pumpkin_transport():
    # Create a new model
    model = gurobi.Model()

    # Decision variables
    T = model.addVar(lb=0, name="T", vtype=gurobi.GRB.INTEGER)  # Number of trucks
    V = model.addVar(lb=0, name="V", vtype=gurobi.GRB.INTEGER)  # Number of vans

    # Objective function: Maximize the total number of pumpkins transported
    model.setObjective(40 * T + 25 * V, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(15 * T + 10 * V <= 300, name="Cost_Constraint")  # Cost constraint
    model.addConstr(T <= V, name="Truck_Van_Constraint")  # Truck and van constraint

    # Solve the model
    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal solution: Trucks = {T.varValue}, Vans = {V.varValue}")
        print(f"Maximum pumpkins transported: {40 * T.varValue + 25 * V.varValue}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("The model is infeasible")
    else:
        print("The model has a non-optimal status")

solve_pumpkin_transport()
