
import gurobipy as gp

# Create a new model
m = gp.Model("TailorShop")

# Create variables
x = m.addVar(vtype=gp.GRB.CONTINUOUS, name="pants")  # Number of pants
y = m.addVar(vtype=gp.GRB.CONTINUOUS, name="shorts") # Number of shorts

# Set objective function
m.setObjective(5*x + 7*y, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.5*x + 0.1*y <= 60, "measuring")
m.addConstr(0.2*x + 0.5*y <= 80, "cutting")
m.addConstr(0.7*x + 0.6*y <= 75, "sewing")

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of pants to make: {x.x}")
    print(f"Number of shorts to make: {y.x}")
    print(f"Maximum Profit: ${m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

