
from gurobipy import *

# Create a new model
m = Model("Tailor_Shop_Optimization")

# Define the decision variables
P = m.addVar(vtype=GRB.CONTINUOUS, name="pants", lb=0)
S = m.addVar(vtype=GRB.CONTINUOUS, name="shorts", lb=0)

# Define the objective function: Maximize profit
m.setObjective(5*P + 7*S, GRB.MAXIMIZE)

# Define the constraints
m.addConstr(0.5*P + 0.1*S <= 60, "measuring_team")
m.addConstr(0.2*P + 0.5*S <= 80, "cutting_team")
m.addConstr(0.7*P + 0.6*S <= 75, "sewing_team")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Pants: {P.x}")
    print(f"Shorts: {S.x}")
    print(f"Maximum Profit: {m.objVal}")
else:
    print("No optimal solution found")
