
import gurobipy as gp

# Create a new model
model = gp.Model("TailorShop")

# Define the decision variables
x_p = model.addVar(name="pants", lb=0, vtype=gp.GRB.CONTINUOUS)
x_s = model.addVar(name="shorts", lb=0, vtype=gp.GRB.CONTINUOUS)

# Define the objective function
model.setObjective(5 * x_p + 7 * x_s, gp.GRB.MAXIMIZE)

# Define the constraints
model.addConstr(0.5 * x_p + 0.1 * x_s <= 60, name="measuring")
model.addConstr(0.2 * x_p + 0.5 * x_s <= 80, name="cutting")
model.addConstr(0.7 * x_p + 0.6 * x_s <= 75, name="sewing")

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Pants: {x_p.varValue:.2f}")
    print(f"Shorts: {x_s.varValue:.2f}")
    print(f"Max Profit: {model.objVal:.2f}")
else:
    print("No optimal solution found.")
