
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("pizza_optimization")

# Create variables
x = m.addVar(vtype=GRB.CONTINUOUS, name="cheese_pizzas") # Allowing fractional pizzas for now
y = m.addVar(vtype=GRB.CONTINUOUS, name="pepperoni_pizzas")

# Set objective function
m.setObjective(7*x + 9*y, GRB.MAXIMIZE)

# Add constraints
m.addConstr(30*x + 40*y <= 3000, "flour_constraint")
m.addConstr(50*x + 20*y <= 4000, "cheese_constraint")
m.addConstr(40*x + 30*y <= 5000, "sauce_constraint")
m.addConstr(x >= 0, "cheese_nonneg")
m.addConstr(y >= 0, "pepperoni_nonneg")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print(f"Optimal number of cheese pizzas: {x.x}")
    print(f"Optimal number of pepperoni pizzas: {y.x}")
    print(f"Optimal profit: ${m.objVal}")

    # Round down to get integer solutions if needed
    print("\nInteger Solution (rounding down):")
    print(f"Cheese pizzas: {int(x.x)}")
    print(f"Pepperoni pizzas: {int(y.x)}")
    print(f"Profit (with rounding): ${7*int(x.x) + 9*int(y.x)}")

