
from gurobipy import *

# Create a new model
model = Model("Pizza_Profit_Optimization")

# Define the decision variables
x_c = model.addVar(vtype=GRB.CONTINUOUS, name="cheese_pizzas", lb=0)
x_p = model.addVar(vtype=GRB.CONTINUOUS, name="pepperoni_pizzas", lb=0)

# Set the objective function
model.setObjective(7*x_c + 9*x_p, GRB.MAXIMIZE)

# Add constraints
model.addConstr(30*x_c + 40*x_p <= 3000, "flour_constraint")
model.addConstr(50*x_c + 20*x_p <= 4000, "cheese_constraint")
model.addConstr(40*x_c + 30*x_p <= 5000, "sauce_constraint")

# Optimize the model
model.optimize()

# Print the results
if model.status == GRB.OPTIMAL:
    print(f"Optimal solution: {x_c.varName} = {x_c.x}, {x_p.varName} = {x_p.x}")
    print(f"Maximum profit: {model.objVal}")
else:
    print("No optimal solution found")

# Output the gurobi model
print(model)
