
import gurobipy as gp

# Create a new model
m = gp.Model("pizza_problem")

# Define the decision variables
x = m.addVar(name="cheese_pizzas", lb=0, vtype=gp.GRB.INTEGER)
y = m.addVar(name="pepperoni_pizzas", lb=0, vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(7 * x + 9 * y, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(30 * x + 40 * y <= 3000, name="flour_constraint")
m.addConstr(50 * x + 20 * y <= 4000, name="cheese_constraint")
m.addConstr(40 * x + 30 * y <= 5000, name="sauce_constraint")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution: x = {x.varValue}, y = {y.varValue}")
    print(f"Maximum profit: ${7 * x.varValue + 9 * y.varValue:.2f}")
else:
    print("No optimal solution found")
