
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("Milk Transportation")

# Create variables
r = m.addVar(vtype=GRB.INTEGER, name="rail_shipments")
t = m.addVar(vtype=GRB.INTEGER, name="truck_shipments")

# Set objective function
m.setObjective(400 * r + 200 * t, GRB.MAXIMIZE)

# Add constraints
m.addConstr(100 * r + 85 * t <= 3000, "budget_constraint")
m.addConstr(r <= t, "rail_limit")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal Solution Found:")
    print(f"Number of rail shipments: {r.x}")
    print(f"Number of truck shipments: {t.x}")
    print(f"Total milk transported: {400 * r.x + 200 * t.x} litres")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

