
from gurobipy import *

# Create a new model
m = Model("Milk Transportation")

# Define decision variables
R = m.addVar(vtype=GRB.INTEGER, name="Rail Shipments")
T = m.addVar(vtype=GRB.INTEGER, name="Truck Shipments")

# Objective function: Maximize total milk transported
m.setObjective(400*R + 200*T, GRB.MAXIMIZE)

# Constraints
m.addConstr(100*R + 85*T <= 3000, "Budget Constraint")
m.addConstr(R <= T, "Rail vs Truck Constraint")

# Non-negativity constraints (since you can't have negative shipments)
m.addConstr(R >= 0, "Non-negative Rail Shipments")
m.addConstr(T >= 0, "Non-negative Truck Shipments")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: {R.varName} = {R.x}, {T.varName} = {T.x}")
    print(f"Total milk transported: {400*R.x + 200*T.x} litres")
else:
    print("No optimal solution found")

