
import gurobi

def solve_milk_transportation():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    R = model.addVar(name="Rail Shipments", vtype=gurobi.GRB.INTEGER)
    T = model.addVar(name="Truck Shipments", vtype=gurobi.GRB.INTEGER)

    # Objective function: Maximize 400R + 200T
    model.setObjective(400*R + 200*T, gurobi.GRB.MAXIMIZE)

    # Budget constraint: 100R + 85T <= 3000
    model.addConstr(100*R + 85*T <= 3000, name="Budget Constraint")

    # Rail shipments cannot exceed truck shipments: R <= T
    model.addConstr(R <= T, name="Rail vs Truck Constraint")

    # Non-negativity constraints are inherently satisfied by using integer variables

    # Solve the model
    model.optimize()

    # Print the results
    if model.status == gurobi.GRB.OPTIMAL:
        print(f"Optimal Solution:")
        print(f"Rail Shipments: {R.varValue}")
        print(f"Truck Shipments: {T.varValue}")
        print(f"Total litres: {400*R.varValue + 200*T.varValue}")
    else:
        print("The model is infeasible.")

solve_milk_transportation()
