
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("trail_mix")

# Create variables
x = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x") # Trail Mix A
y = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="y") # Trail Mix B


# Set objective function
m.setObjective(5*x + 8*y, GRB.MINIMIZE)

# Add constraints
m.addConstr(2*x + 2*y >= 20, "almond_constraint")
m.addConstr(x + 3*y >= 15, "chocolate_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found. Cost: {m.objVal}")
    print(f"Bags of Trail Mix A: {x.x}")
    print(f"Bags of Trail Mix B: {y.x}")
elif m.status == GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

