
from gurobipy import *

# Create a new model
m = Model("Trail_Mix_Optimization")

# Add decision variables to the model
x_A = m.addVar(vtype=GRB.CONTINUOUS, name="trail_mix_A", lb=0)
x_B = m.addVar(vtype=GRB.CONTINUOUS, name="trail_mix_B", lb=0)

# Set the objective function: minimize total cost
m.setObjective(5*x_A + 8*x_B, GRB.MINIMIZE)

# Add constraints to the model
m.addConstr(2*x_A + 2*x_B >= 20, "almonds_constraint")
m.addConstr(x_A + 3*x_B >= 15, "chocolate_chips_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print(f"Optimal solution found: Buy {x_A.x:.2f} bags of Trail Mix A and {x_B.x:.2f} bags of Trail Mix B.")
    print(f"Total cost: ${m.objVal:.2f}")
else:
    print("No optimal solution found. The problem might be infeasible.")
