
import gurobi

def solve_trail_mix_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the decision variables
    x_A = model.addVar(lb=0, name="Trail_Mix_A")
    x_B = model.addVar(lb=0, name="Trail_Mix_B")

    # Define the objective function: minimize cost
    model.setObjective(5 * x_A + 8 * x_B, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(2 * x_A + 2 * x_B >= 20, name="Almonds_Constraint")
    model.addConstr(x_A + 3 * x_B >= 15, name="Chocolate_Constraint")

    # Optimize the model
    model.optimize()

    # Check if the model is optimized
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Trail Mix A: {x_A.varValue} bags")
        print(f"Trail Mix B: {x_B.varValue} bags")
        print(f"Total Cost: ${model.objVal:.2f}")
    else:
        print("The model is infeasible or no solution exists.")

# Run the function
solve_trail_mix_problem()
