
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("Investment_Problem")

    # Create variables
    x = m.addVar(name="fertilizer_investment")
    y = m.addVar(name="pesticide_investment")

    # Set objective function
    m.setObjective(0.14 * x + 0.15 * y, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(x + y <= 5000, "total_investment")
    m.addConstr(x >= 0.5 * (x + y), "min_fertilizer_investment")
    m.addConstr(y >= 1000, "min_pesticide_investment")
    m.addConstr(x >=0)
    m.addConstr(y >=0)


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print(f"Optimal profit: ${m.objVal:.2f}")
        print(f"Invest ${x.x:.2f} in fertilizer company")
        print(f"Invest ${y.x:.2f} in pesticide company")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
